# Contributing to WebViewer UI

## Issues
1. Check existing issues (open/closed) to avoid duplicates.
2. Be clear about what the problem is.
3. Make sure to paste error output or logs.
4. Code snapshot or demos on online code editor will be very helpful.

## Pull requests
1. Fork the repository.
2. Create a branch from `master`.
3. Update the source code using style guides described below.
4. Lint your code with `npm run lint`.
5. Commit and push the changes with descriptive messages.
6. Create a pull request to `master`.

\* Please note that all pull requests should be tied to an issue, and all but the most trivial pull requests should be discussed before hand.

## Style guides
- Tab indentation (size of 2 spaces).
- `'` instead of `"`.
- Curly braces for block statements.
- 1TBS brace style.
- Semicolon at the end of each statement.
- Object shorthand for ES6.
- Parenthesis around arrow function argument.
- Minimum line breaks.
- No `use strict`.